# 📋 Sistema de Gestão de Gabinete

## 🎯 Visão Geral

O **Sistema de Gestão de Gabinete** é uma aplicação web completa desenvolvida em PHP para auxiliar na administração e organização de atividades de gabinetes políticos. O sistema oferece ferramentas integradas para gerenciamento de agenda, eleitores, documentos e relatórios estatísticos.

## 🚀 Funcionalidades Principais

### 📅 **Agenda de Compromissos**
- **Calendário Interativo**: Visualização em mês, semana, dia e lista
- **Agendamentos Rápidos**: Clique em qualquer data para criar eventos
- **Categorização**: Reuniões, visitas, ações sociais, saúde, jurídico
- **Integração Google Calendar**: Sincronização automática (opcional)
- **Associação com Eleitores**: Vincule eventos a pessoas específicas

### 📁 **Gestão de Documentos**
- **Upload Seguro**: Suporte a PDF, DOCX, PNG, JPG
- **Categorização**: Ofícios, requerimentos, projetos, prestação de contas
- **Sistema de Busca**: Filtros por categoria e data
- **Controle de Acesso**: Rastreamento de quem enviou cada documento
- **Download Direto**: Acesso rápido aos arquivos armazenados

### 👥 **Cadastro de Eleitores**
- **Dados Completos**: Informações pessoais, contato e endereço
- **Classificação**: Apoiadores e lideranças
- **Registro de Demandas**: Histórico de solicitações por eleitor
- **Ações Rápidas**: Visualizar, editar e excluir registros
- **Busca Avançada**: Localização por nome, bairro ou telefone

### 📊 **Relatórios e Estatísticas**
- **Dashboard Interativo**: Gráficos em tempo real
- **Análise Demográfica**: Distribuição por sexo, idade e localização
- **Mapeamento Territorial**: Top 10 bairros com maior apoio
- **Análise de Demandas**: Categorias mais solicitadas
- **Exportação PDF**: Relatórios para apresentações
- **Dados em Tempo Real**: Atualizações automáticas

### 🛡️ **Painel Administrativo**
- **Controle de Usuários**: Criar, editar e gerenciar contas
- **Níveis de Acesso**: Admin, Assessor, Estagiário
- **Estatísticas do Sistema**: Visão geral de uso e dados
- **Auditoria**: Logs de atividades e acessos
- **Configurações**: Personalização do sistema

### ⚙️ **Configurações**
- **Perfil do Usuário**: Gerenciamento de conta pessoal
- **Integrações**: Conexão com Google Calendar
- **Preferências**: Personalização da interface
- **Segurança**: Alteração de senhas e configurações de acesso

## 🏗️ Arquitetura do Sistema

### **Estrutura MVC (Model-View-Controller)**
\`\`\`
gabinete/
├── index.php                 # Roteador principal
├── src/
│   ├── config/               # Configurações
│   │   ├── config.php        # Banco de dados e URLs
│   │   └── log.php           # Sistema de logs
│   ├── controllers/          # Controladores
│   │   ├── AgendasController.php
│   │   ├── DocumentosController.php
│   │   ├── EleitoresController.php
│   │   ├── RelatoriosController.php
│   │   ├── PaineladminController.php
│   │   └── UsuarioController.php
│   ├── models/               # Modelos de dados
│   │   ├── Usuario.php
│   │   ├── Eleitor.php
│   │   ├── Documento.php
│   │   ├── Agenda.php
│   │   └── Relatorio.php
│   ├── views/                # Interfaces
│   │   ├── partials/         # Componentes reutilizáveis
│   │   ├── agendas/          # Páginas da agenda
│   │   ├── documentos/       # Páginas de documentos
│   │   ├── eleitores/        # Páginas de eleitores
│   │   └── relatorios/       # Páginas de relatórios
│   └── helpers/              # Funções auxiliares
│       └── AuthHelper.php    # Controle de autenticação
├── public/                   # Arquivos públicos
│   ├── css/                  # Estilos
│   └── js/                   # Scripts JavaScript
└── uploads/                  # Arquivos enviados
    └── documentos/           # Documentos armazenados
\`\`\`

## 💾 Banco de Dados

### **Tabelas Principais**
- **usuarios**: Contas de acesso ao sistema
- **eleitores**: Cadastro de apoiadores e lideranças
- **agendas**: Eventos e compromissos
- **documentos**: Arquivos e documentação
- **demandas**: Solicitações e demandas dos eleitores

## 🔧 Requisitos Técnicos

### **Servidor**
- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Apache/Nginx
- Extensões: PDO, GD, FileInfo

### **Cliente**
- Navegador moderno (Chrome, Firefox, Safari, Edge)
- JavaScript habilitado
- Resolução mínima: 1024x768

## 📦 Instalação

### **1. Preparação do Ambiente**
```bash
# Clone ou extraia os arquivos do sistema
# Configure seu servidor web (MAMP, XAMPP, WAMP)
